/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import com.bdlington.Catalyst.modules.HoleTunnelStairs;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;

public class CoveredVeinEsp
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final Setting<Boolean> chatNotifications;
    private final Setting<Boolean> onlyPlayerCovered;
    private final Setting<Integer> maxThreads;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<SettingColor> lineColor;
    private final Setting<SettingColor> sideColor;
    private final Map<class_238, CoveredHoleInfo> coveredHoles;
    private final Set<class_238> processedHoles;
    private final Set<class_238> pendingProcessing;
    private final Set<class_238> notifiedHoles;
    private ExecutorService executorService;
    private final List<Future<Map.Entry<class_238, CoveredHoleInfo>>> pendingTasks;
    private final Map<class_2338, Boolean> solidBlockCache;
    private final Map<class_2338, class_2680> blockStateCache;
    private HoleTunnelStairs holeESP;
    private int tickCounter;
    private volatile boolean isScanning;
    private long lastCacheClear;
    private long lastCheckTime;
    private String currentWorld;

    public CoveredVeinEsp() {
        super(CatalystAddon.esp, "covered-hole", "Detects covered holes from HoleTunnelStairs with performance optimization.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.chatNotifications = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-notifications")).description("Send chat messages when covered holes are found")).defaultValue((Object)true)).build());
        this.onlyPlayerCovered = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-player-covered")).description("Only detect holes that appear to be intentionally covered")).defaultValue((Object)true)).build());
        this.maxThreads = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-threads")).description("Maximum number of threads to use for scanning")).defaultValue((Object)4)).min(1).max(8).build());
        this.shapeMode = this.sgRender.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered")).defaultValue((Object)ShapeMode.Both)).build());
        this.lineColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("The color of the lines for covered holes")).defaultValue(new SettingColor(255, 165, 0, 255)).build());
        this.sideColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("The color of the sides for covered holes")).defaultValue(new SettingColor(255, 165, 0, 50)).build());
        this.coveredHoles = new ConcurrentHashMap<class_238, CoveredHoleInfo>();
        this.processedHoles = ConcurrentHashMap.newKeySet();
        this.pendingProcessing = ConcurrentHashMap.newKeySet();
        this.notifiedHoles = ConcurrentHashMap.newKeySet();
        this.pendingTasks = new ArrayList<Future<Map.Entry<class_238, CoveredHoleInfo>>>();
        this.solidBlockCache = new ConcurrentHashMap<class_2338, Boolean>();
        this.blockStateCache = new ConcurrentHashMap<class_2338, class_2680>();
        this.tickCounter = 0;
        this.isScanning = false;
        this.lastCacheClear = 0L;
        this.lastCheckTime = 0L;
        this.currentWorld = "";
    }

    public void onActivate() {
        this.executorService = Executors.newFixedThreadPool((Integer)this.maxThreads.get());
        this.holeESP = (HoleTunnelStairs)Modules.get().get(HoleTunnelStairs.class);
        if (this.holeESP == null || !this.holeESP.isActive()) {
            this.error("HoleTunnelStairsESP must be active for CoveredHole to work!", new Object[0]);
            this.toggle();
            return;
        }
        this.clearAllData();
        if (this.mc.field_1687 != null) {
            this.currentWorld = this.mc.field_1687.method_27983().method_29177().toString();
        }
    }

    public void onDeactivate() {
        this.shutdownExecutor();
        this.clearAllData();
    }

    private void clearAllData() {
        this.coveredHoles.clear();
        this.processedHoles.clear();
        this.pendingProcessing.clear();
        this.solidBlockCache.clear();
        this.blockStateCache.clear();
        this.pendingTasks.clear();
        this.notifiedHoles.clear();
        this.isScanning = false;
        this.tickCounter = 0;
        this.lastCacheClear = System.currentTimeMillis();
        this.lastCheckTime = 0L;
    }

    private void shutdownExecutor() {
        if (this.executorService != null) {
            this.isScanning = false;
            for (Future<Map.Entry<class_238, CoveredHoleInfo>> task : this.pendingTasks) {
                task.cancel(true);
            }
            this.pendingTasks.clear();
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private void checkWorldChange() {
        if (this.mc.field_1687 == null) {
            this.currentWorld = "";
            this.clearAllData();
            return;
        }
        String newWorld = this.mc.field_1687.method_27983().method_29177().toString();
        if (!newWorld.equals(this.currentWorld)) {
            this.currentWorld = newWorld;
            this.clearAllData();
        }
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        this.checkWorldChange();
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        if (this.holeESP == null || !this.holeESP.isActive()) {
            this.error("HoleTunnelStairsESP was disabled!", new Object[0]);
            this.toggle();
            return;
        }
        ++this.tickCounter;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCacheClear > 5000L) {
            this.clearOldCacheEntries();
            this.lastCacheClear = currentTime;
        }
        if (currentTime - this.lastCheckTime > 5000L) {
            this.startAsyncScan();
            this.lastCheckTime = currentTime;
        }
        this.processCompletedTasks();
    }

    private void clearOldCacheEntries() {
        if (this.solidBlockCache.size() > 1000) {
            this.solidBlockCache.clear();
        }
        if (this.blockStateCache.size() > 1000) {
            this.blockStateCache.clear();
        }
    }

    private void startAsyncScan() {
        Set<class_238> holes = this.getHolesFromHoleESP();
        if (holes == null || holes.isEmpty()) {
            return;
        }
        this.isScanning = true;
        ArrayList<class_238> newHoles = new ArrayList<class_238>();
        for (class_238 hole : holes) {
            if (this.processedHoles.contains(hole) || this.pendingProcessing.contains(hole)) continue;
            newHoles.add(hole);
            this.pendingProcessing.add(hole);
        }
        int maxConcurrentTasks = Math.min(newHoles.size(), (Integer)this.maxThreads.get());
        for (int i = 0; i < maxConcurrentTasks; ++i) {
            if (i >= newHoles.size()) continue;
            Future<Map.Entry<class_238, CoveredHoleInfo>> future = this.executorService.submit(new HoleCheckTask((class_238)newHoles.get(i)));
            this.pendingTasks.add(future);
        }
        this.coveredHoles.keySet().retainAll(holes);
        this.processedHoles.retainAll(holes);
        this.pendingProcessing.retainAll(holes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCompletedTasks() {
        Iterator<Future<Map.Entry<class_238, CoveredHoleInfo>>> iterator = this.pendingTasks.iterator();
        int processedCount = 0;
        int maxProcessPerTick = 3;
        while (iterator.hasNext() && processedCount < 3) {
            Future<Map.Entry<class_238, CoveredHoleInfo>> task = iterator.next();
            if (!task.isDone()) continue;
            try {
                Map.Entry<class_238, CoveredHoleInfo> result = task.get(1L, TimeUnit.MILLISECONDS);
                if (result == null) continue;
                this.coveredHoles.put(result.getKey(), result.getValue());
                this.pendingProcessing.remove(result.getKey());
                if (!((Boolean)this.chatNotifications.get()).booleanValue() || this.notifiedHoles.contains(result.getKey())) continue;
                class_238 hole = result.getKey();
                class_2338 coverPos = result.getValue().coverPos;
                int depth = (int)(hole.field_1325 - hole.field_1322);
                this.info(String.format("Covered Hole found at %s (depth: %d)", coverPos.method_23854(), depth), new Object[0]);
                this.notifiedHoles.add(result.getKey());
            }
            catch (Exception exception) {}
            continue;
            finally {
                iterator.remove();
                ++processedCount;
            }
        }
        if (this.pendingTasks.isEmpty()) {
            this.isScanning = false;
        }
    }

    private Set<class_238> getHolesFromHoleESP() {
        try {
            return this.holeESP != null ? this.holeESP.getHoles() : Collections.emptySet();
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        if (this.mc.field_1687 == null) {
            return;
        }
        for (Map.Entry<class_238, CoveredHoleInfo> entry : this.coveredHoles.entrySet()) {
            class_238 hole = entry.getKey();
            CoveredHoleInfo info = entry.getValue();
            try {
                event.renderer.box(hole.field_1323, hole.field_1322, hole.field_1321, hole.field_1320, hole.field_1325, hole.field_1324, (Color)this.sideColor.get(), (Color)this.lineColor.get(), (ShapeMode)this.shapeMode.get(), 0);
                event.renderer.box((double)info.coverPos.method_10263(), (double)info.coverPos.method_10264(), (double)info.coverPos.method_10260(), (double)(info.coverPos.method_10263() + 1), (double)(info.coverPos.method_10264() + 1), (double)(info.coverPos.method_10260() + 1), (Color)this.sideColor.get(), (Color)this.lineColor.get(), (ShapeMode)this.shapeMode.get(), 0);
            }
            catch (Exception exception) {}
        }
    }

    private class HoleCheckTask
    implements Callable<Map.Entry<class_238, CoveredHoleInfo>> {
        private final class_238 hole;

        public HoleCheckTask(class_238 hole) {
            this.hole = hole;
        }

        @Override
        public Map.Entry<class_238, CoveredHoleInfo> call() {
            try {
                if (((CoveredVeinEsp)CoveredVeinEsp.this).mc.field_1687 == null) {
                    return null;
                }
                class_2338 topPos = new class_2338((int)this.hole.field_1323, (int)this.hole.field_1325, (int)this.hole.field_1321);
                if (this.isSolidBlockCached(topPos)) {
                    boolean isPlayerCovered;
                    boolean bl = isPlayerCovered = (Boolean)CoveredVeinEsp.this.onlyPlayerCovered.get() == false || this.isLikelyPlayerCovered(topPos, this.hole);
                    if (isPlayerCovered) {
                        return new AbstractMap.SimpleEntry<class_238, CoveredHoleInfo>(this.hole, new CoveredHoleInfo(topPos, this.hole));
                    }
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }

        private boolean isLikelyPlayerCovered(class_2338 coverPos, class_238 hole) {
            try {
                class_2338[] checkPositions;
                class_2680 coverBlock = this.getBlockStateCached(coverPos);
                if (coverBlock == null) {
                    return false;
                }
                if (this.isCommonBuildingBlock(coverBlock)) {
                    return true;
                }
                int matchingBlocks = 0;
                for (class_2338 pos : checkPositions = new class_2338[]{coverPos.method_10095(), coverPos.method_10072(), coverPos.method_10078(), coverPos.method_10067()}) {
                    class_2680 state = this.getBlockStateCached(pos);
                    if (state == null || state.method_26204() != coverBlock.method_26204()) continue;
                    ++matchingBlocks;
                }
                return matchingBlocks < 2;
            }
            catch (Exception e) {
                return false;
            }
        }

        private boolean isCommonBuildingBlock(class_2680 state) {
            if (state == null) {
                return false;
            }
            String blockName = state.method_26204().method_63499().toLowerCase();
            return blockName.contains("cobblestone") || blockName.contains("stone_brick") || blockName.contains("plank") || blockName.contains("log") || blockName.contains("wool") || blockName.contains("concrete") || blockName.contains("terracotta") || blockName.contains("glass");
        }

        private boolean isSolidBlockCached(class_2338 pos) {
            if (((CoveredVeinEsp)CoveredVeinEsp.this).mc.field_1687 == null) {
                return false;
            }
            return CoveredVeinEsp.this.solidBlockCache.computeIfAbsent(pos, p -> {
                try {
                    class_2680 state = ((CoveredVeinEsp)CoveredVeinEsp.this).mc.field_1687.method_8320(p);
                    return state != null && state.method_26212((class_1922)((CoveredVeinEsp)CoveredVeinEsp.this).mc.field_1687, p);
                }
                catch (Exception e) {
                    return false;
                }
            });
        }

        private class_2680 getBlockStateCached(class_2338 pos) {
            if (((CoveredVeinEsp)CoveredVeinEsp.this).mc.field_1687 == null) {
                return null;
            }
            return CoveredVeinEsp.this.blockStateCache.computeIfAbsent(pos, p -> {
                try {
                    return ((CoveredVeinEsp)CoveredVeinEsp.this).mc.field_1687.method_8320(p);
                }
                catch (Exception e) {
                    return null;
                }
            });
        }
    }

    private static class CoveredHoleInfo {
        public final class_2338 coverPos;
        public final class_238 holeBox;

        public CoveredHoleInfo(class_2338 coverPos, class_238 holeBox) {
            this.coverPos = coverPos;
            this.holeBox = holeBox;
        }
    }
}

